/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v118.profiler;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v118.profiler.model.ConsoleProfileFinished;
import org.openqa.selenium.devtools.v118.profiler.model.ConsoleProfileStarted;
import org.openqa.selenium.devtools.v118.profiler.model.PreciseCoverageDeltaUpdate;
import org.openqa.selenium.devtools.v118.profiler.model.Profile;
import org.openqa.selenium.devtools.v118.profiler.model.ScriptCoverage;
import org.openqa.selenium.json.JsonInput;

public class Profiler {
    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Profiler.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Profiler.enable", Map.copyOf(params));
    }

    public static Command<List<ScriptCoverage>> getBestEffortCoverage() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Profiler.getBestEffortCoverage", Map.copyOf(params), ConverterFunctions.map((String)"result", input -> input.readArray(ScriptCoverage.class)));
    }

    public static Command<Void> setSamplingInterval(Integer interval) {
        Objects.requireNonNull(interval, "interval is required");
        LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        params.put("interval", interval);
        return new Command("Profiler.setSamplingInterval", Map.copyOf(params));
    }

    public static Command<Void> start() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Profiler.start", Map.copyOf(params));
    }

    public static Command<Number> startPreciseCoverage(Optional<Boolean> callCount, Optional<Boolean> detailed, Optional<Boolean> allowTriggeredUpdates) {
        LinkedHashMap params = new LinkedHashMap();
        callCount.ifPresent(p -> params.put("callCount", p));
        detailed.ifPresent(p -> params.put("detailed", p));
        allowTriggeredUpdates.ifPresent(p -> params.put("allowTriggeredUpdates", p));
        return new Command("Profiler.startPreciseCoverage", Map.copyOf(params), ConverterFunctions.map((String)"timestamp", Number.class));
    }

    public static Command<Profile> stop() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Profiler.stop", Map.copyOf(params), ConverterFunctions.map((String)"profile", Profile.class));
    }

    public static Command<Void> stopPreciseCoverage() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Profiler.stopPreciseCoverage", Map.copyOf(params));
    }

    public static Command<TakePreciseCoverageResponse> takePreciseCoverage() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Profiler.takePreciseCoverage", Map.copyOf(params), input -> (TakePreciseCoverageResponse)input.read(TakePreciseCoverageResponse.class));
    }

    public static Event<ConsoleProfileFinished> consoleProfileFinished() {
        return new Event("Profiler.consoleProfileFinished", input -> (ConsoleProfileFinished)input.read(ConsoleProfileFinished.class));
    }

    public static Event<ConsoleProfileStarted> consoleProfileStarted() {
        return new Event("Profiler.consoleProfileStarted", input -> (ConsoleProfileStarted)input.read(ConsoleProfileStarted.class));
    }

    public static Event<PreciseCoverageDeltaUpdate> preciseCoverageDeltaUpdate() {
        return new Event("Profiler.preciseCoverageDeltaUpdate", input -> (PreciseCoverageDeltaUpdate)input.read(PreciseCoverageDeltaUpdate.class));
    }

    public static class TakePreciseCoverageResponse {
        private final List<ScriptCoverage> result;
        private final Number timestamp;

        public TakePreciseCoverageResponse(List<ScriptCoverage> result, Number timestamp) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        }

        public List<ScriptCoverage> getResult() {
            return this.result;
        }

        public Number getTimestamp() {
            return this.timestamp;
        }

        private static TakePreciseCoverageResponse fromJson(JsonInput input) {
            List result = null;
            Number timestamp = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = input.readArray(ScriptCoverage.class);
                        continue block8;
                    }
                    case "timestamp": {
                        timestamp = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new TakePreciseCoverageResponse(result, timestamp);
        }
    }
}

